//
//  MCDurationFormatter.h
//  MCFoundation
//
//  Created by Michael Clark on 17/04/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum { 
	MCDurationMinutesSecondsMode = 10, 
	MCDurationHoursMinutesMode = 11, 
	MCDurationHoursMinutesSecondsMode = 12, 
	MCDurationDaysMode = 13,
	MCDurationNaturalLanguageMode = 14,
    MCDurationHoursAsDecimalMode = 15,
	MCDurationShortFormMode = 16
} MCDurationMode;

@interface MCDurationFormatter : NSFormatter {

	MCDurationMode   _mode;
	BOOL showPartialSeconds;
	
}

/*
 %h %m = hour minute
 %m %s = minute second
 %h %m %s = hour minute second
 */
- (void)setFormat:(NSString *)aFormat;

#pragma mark LocalizedStrings
	// DAY
- (NSString *)localizedDayString;
- (NSString *)localizedPluralDayString;

	// WEEK
- (NSString *)localizedWeekString;
- (NSString *)localizedPluralWeekString;

	// MONTH
- (NSString *)localizedMonthString;
- (NSString *)localizedPluralMonthString;

	// YEAR
- (NSString *)localizedYearString;
- (NSString *)localizedPluralYearString;

	// HOUR
- (NSString *)localizedHourString;
- (NSString *)localizedPluralHourString;

	// MINUTE
- (NSString *)localizedMinuteString;
- (NSString *)localizedPluralMinuteString;

   // SECOND
- (NSString *)localizedSecondString;
- (NSString *)localizedPluralSecondString;

#pragma mark Accessors
- (MCDurationMode)mode;
- (void)setMode:(MCDurationMode)aMode;
//- (void)setModeCorrespondingToString:(NSString*)aModeString;

- (BOOL)showPartialSeconds;
- (void)setShowPartialSeconds:(BOOL)flag;

@end
